(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15382,        402]
NotebookOptionsPosition[     14454,        379]
NotebookOutlinePosition[     14792,        394]
CellTagsIndexPosition[     14749,        391]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "average", " ", "front", " ", "time", " ", "trace"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "99"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"analysis", "=", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{"\"\<pars_\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
         "\"\</rng_\>\"", "<>", 
         RowBox[{"ToString", "[", "k", "]"}], "<>", "\"\</Analysis.h5\>\""}], 
        ",", "\"\</FrontPosition\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", 
         RowBox[{"(", 
          RowBox[{"\"\<Variance\>\"", "+", 
           RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cfg", "+=", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<CELL_DISSIPATION\>\"", "/.", 
        RowBox[{"(", 
         RowBox[{"\"\<POPULATION\>\"", "/.", 
          RowBox[{"Import", "[", 
           RowBox[{"\"\<pars_\>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
            "\"\</rng_\>\"", "<>", 
            RowBox[{"ToString", "[", "k", "]"}], "<>", 
            "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
   RowBox[{
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "/=", "100"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.7498187558942633`*^9, {3.749818787198708*^9, 3.7498187886729193`*^9}, {
   3.776536203117805*^9, 3.776536208654155*^9}, {3.776536258451468*^9, 
   3.776536293590169*^9}, {3.77653671450404*^9, 
   3.776536717373015*^9}},ExpressionUUID->"c9c001ea-12bd-4102-bb53-\
5547682c7cc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "dissipation", " ", "value"}], "*)"}], 
  "\[IndentingNewLine]", "cfg"}]], "Input",
 CellChangeTimes->{{3.776536676472872*^9, 
  3.7765366865239162`*^9}},ExpressionUUID->"9ac7b150-9ddc-46e9-9f84-\
e3f2a2d25367"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "time", " ", "trace"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_A_100.dat\>\"", ",", "result"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.749818942527513*^9, 3.749819016898625*^9}, {
  3.749983983699026*^9, 3.749984044253263*^9}, {3.776536691775498*^9, 
  3.776536699953127*^9}},ExpressionUUID->"860367a0-f66b-4b75-bbfc-\
60a83db59b38"],

Cell[BoxData["\<\"~/Downloads/tissue_A_100.dat\"\>"], "Output",
 CellChangeTimes->{{3.7498189632432756`*^9, 3.7498190203662443`*^9}, {
  3.749983986550441*^9, 
  3.7499840454589663`*^9}},ExpressionUUID->"79861b82-4c08-4f7d-b923-\
d979276377bc"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "tissue", " ", "properties", " ", "depending", " ", "on", " ", 
    "cell", " ", "dissipation"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resultarray", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"finalresult", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cfg", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"analysis", "=", 
            RowBox[{"Import", "[", 
             RowBox[{
              RowBox[{"\"\<pars_\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
               "\"\</rng_\>\"", "<>", 
               RowBox[{"ToString", "[", "k", "]"}], "<>", 
               "\"\</Analysis.h5\>\""}], ",", "\"\</FrontPosition\>\""}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", 
               RowBox[{"(", 
                RowBox[{"\"\<Variance\>\"", "+", 
                 RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"cfg", "+=", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<CELL_DISSIPATION\>\"", "/.", 
              RowBox[{"(", 
               RowBox[{"\"\<POPULATION\>\"", "/.", 
                RowBox[{"Import", "[", 
                 RowBox[{"\"\<pars_\>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{
                    RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
                  "\"\</rng_\>\"", "<>", 
                  RowBox[{"ToString", "[", "k", "]"}], "<>", 
                  "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
          "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
         RowBox[{
          RowBox[{"result", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cfg", "/=", "100"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"resultarray", ",", "result"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"cfg", ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"Mean", "[", 
           RowBox[{
            RowBox[{"Sqrt", "@", 
             RowBox[{"result", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"200", ";;", 
                 RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], "/", 
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"200", ";;", 
                RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], "]"}]}], 
         "}"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "0", ",", "99"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n", ",", "k"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7469611432785597`*^9, 3.746961144276451*^9}, {
   3.746965281869259*^9, 3.746965459873785*^9}, {3.746965498987928*^9, 
   3.746965667889323*^9}, {3.7469748860070477`*^9, 3.74697491872473*^9}, {
   3.746974949416271*^9, 3.7469750794926558`*^9}, {3.7469751268254347`*^9, 
   3.746975131510262*^9}, {3.746975184142248*^9, 3.746975208871375*^9}, {
   3.7469752432553988`*^9, 3.7469752435576773`*^9}, {3.746975275545196*^9, 
   3.746975300213953*^9}, {3.746975811139539*^9, 3.746975835250311*^9}, {
   3.747295250876471*^9, 3.7472952543825197`*^9}, {3.7472953335387707`*^9, 
   3.7472954302408648`*^9}, {3.74729549143955*^9, 3.747295505649798*^9}, {
   3.7472955479207067`*^9, 3.7472955700068283`*^9}, {3.747295608263852*^9, 
   3.747295624632111*^9}, {3.747295696061473*^9, 3.7472957039784718`*^9}, {
   3.747295856557472*^9, 3.7472958576972857`*^9}, {3.747462376603374*^9, 
   3.7474623972365522`*^9}, {3.7475423561524973`*^9, 3.747542360860826*^9}, {
   3.749484816344467*^9, 3.74948482186034*^9}, {3.749484912770645*^9, 
   3.749485064468494*^9}, {3.7494854510000553`*^9, 3.749485454495776*^9}, {
   3.7494855579559803`*^9, 3.749485558916917*^9}, {3.749485598799759*^9, 
   3.749485604805133*^9}, 3.7495270040525913`*^9, {3.749993286865794*^9, 
   3.7499933038901787`*^9}, {3.7765362031307592`*^9, 3.776536208657091*^9}, {
   3.776536738194125*^9, 3.776536739206399*^9}, {3.776536812748856*^9, 
   3.776536861693523*^9}, {3.7765369528232393`*^9, 3.776536957918127*^9}, {
   3.7765372088646393`*^9, 
   3.776537247158371*^9}},ExpressionUUID->"4fcce424-4313-4a2d-877b-\
803122798cb3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"#1", " ", "Cell"}], "-", 
    RowBox[{"cell", " ", "dissipation"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "maximum", " ", "expansion"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "maximum", " ", "variance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "average", " ", "roughness", " ", 
    RowBox[{"(", 
     RowBox[{
     "standard", " ", "deviation", " ", "relative", " ", "to", " ", 
      "expanion"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_A.dat\>\"", ",", "finalresult"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7474636050837317`*^9, 3.747463613504825*^9}, {
  3.747463657079228*^9, 3.747463667162775*^9}, {3.7495269934278727`*^9, 
  3.74952699366398*^9}, {3.7765369705654984`*^9, 3.776536995297536*^9}, {
  3.776537112014409*^9, 
  3.776537188290071*^9}},ExpressionUUID->"1cd23770-9341-46f0-9e68-\
a2f83469e71d"],

Cell[BoxData["\<\"~/Downloads/tissue_A.dat\"\>"], "Output",
 CellChangeTimes->{3.747463667700366*^9, 3.749527593185503*^9, 
  3.749983962022409*^9, 3.74999408225817*^9, 
  3.749994306990736*^9},ExpressionUUID->"3d8365a9-bde6-40ec-b3b8-\
b0ce07c09a1a"]
}, Open  ]]
},
WindowSize->{808, 656},
WindowMargins->{{Automatic, 163}, {60, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3985, 114, 472, "Input",ExpressionUUID->"c9c001ea-12bd-4102-bb53-5547682c7cc1"],
Cell[4546, 136, 280, 7, 52, "Input",ExpressionUUID->"9ac7b150-9ddc-46e9-9f84-e3f2a2d25367"],
Cell[CellGroupData[{
Cell[4851, 147, 468, 11, 52, "Input",ExpressionUUID->"860367a0-f66b-4b75-bbfc-60a83db59b38"],
Cell[5322, 160, 244, 4, 34, "Output",ExpressionUUID->"79861b82-4c08-4f7d-b923-d979276377bc"]
}, Open  ]],
Cell[5581, 167, 7394, 171, 598, "Input",ExpressionUUID->"4fcce424-4313-4a2d-877b-803122798cb3"],
Cell[CellGroupData[{
Cell[13000, 342, 1184, 28, 136, "Input",ExpressionUUID->"1cd23770-9341-46f0-9e68-a2f83469e71d"],
Cell[14187, 372, 251, 4, 34, "Output",ExpressionUUID->"3d8365a9-bde6-40ec-b3b8-b0ce07c09a1a"]
}, Open  ]]
}
]
*)

